/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.utils.JsonUtils;

public record ModifierSlotModule(SlotType type, int count) implements VolatileDataModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
    public static final GenericLoaderRegistry.IGenericLoader<ModifierSlotModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ModifierSlotModule>(){

        @Override
        public ModifierSlotModule deserialize(JsonObject json) {
            String slotName = class_3518.method_15265((JsonObject)json, (String)"name");
            if (!SlotType.isValidName(slotName)) {
                throw new JsonSyntaxException("Invalid slot type name '" + slotName + "'");
            }
            int count = JsonUtils.getIntMin(json, "count", 1);
            return new ModifierSlotModule(SlotType.getOrCreate(slotName), count);
        }

        @Override
        public void serialize(ModifierSlotModule object, JsonObject json) {
            json.addProperty("name", object.type.getName());
            json.addProperty("count", (Number)object.count);
        }

        @Override
        public ModifierSlotModule fromNetwork(class_2540 buffer) {
            SlotType type = SlotType.read(buffer);
            int slotCount = buffer.method_10816();
            return new ModifierSlotModule(type, slotCount);
        }

        @Override
        public void toNetwork(ModifierSlotModule object, class_2540 buffer) {
            object.type.write(buffer);
            buffer.method_10804(object.count);
        }
    };

    public ModifierSlotModule(SlotType type) {
        this(type, 1);
    }

    @Override
    public Integer getPriority() {
        return 50;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        volatileData.addSlots(this.type, modifier.getLevel() * this.count);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }
}

